/**
* Script: physics.js
* Written by: Radnen
* Updated: 8/22/2010
**/

var Physics = ({
	/**
	* grabDistance(vect1, vect2);
	*  - returns a distance between two vectors.
	**/
	grabDistance: function(v1, v2) {
		return this.subtractVectors(v1, v2).length;
	},
	
	/**
	* addVectors(v1, v2);
	*  - returns a new vector from 'v1' added by 'v2'.
	**/
	addVectors: function(v1, v2) {
		return new Vector(v1.x + v2.x, v1.y + v2.y);
	},
	
	/**
	* subtractVectors(v1, v2);
	*  - returns a new vector from 'v1' subtracted by 'v2'.
	**/
	subtractVectors: function(v1, v2) {
		return new Vector(v1.x - v2.x, v1.y - v2.y);
	},
	
	/**
	* scaleVector(vect, scale);
	*  - returns a new vector scaled from 'v' by 'scale' times.
	**/
	scaleVectors: function(v, scale) {
		return new Vector(v.x * scale, v.y * scale);
	},
	
	/**
	* normalize(v);
	*  - returns a normalized vector from vector 'v';
	**/
	normalize: function(v) {
		var l = v.length;
		return new Vector(v.x/l, v.y/l);
	},
	
	/**
	* getAngleBetween(v1, v2);
	*  - returns the angle between the vectors 'v1' and 'v2'.
	**/
	getAngleBetween: function(v1, v2) {
		return Math.acos((v1.dot(v2))/(v1.length*v2.length));
	},
	
	/**
	* rotateVector(v, r);
	*  - rotates vector 'v' by 'r' radians.
	**/
	rotateVector: function(v, r) {
		var a_cos = Math.cos(r);
		var a_sin = Math.sin(r);
		return new Vector(v.x*a_cos - v.y*a_sin, v.x*a_sin + v.y*a_cos);
	},
	
	/**
	* aimAheadTime();
	*  - returns the time it takes for one vector to reach
	*    another vector. -1 if impossible.
	*  - delta: relative distance between targets.
	*  - vr: relative velocity between targets.
	*  - vel: projectile speed.
	**/
	aimAheadTime: function(delta, vr, vel) {
		var a = vr.dot(vr) - vel*vel;
		var b = 2 * vr.dot(delta);
		var c = delta.dot(delta);
		
		var det = b*b - 4*a*c;
		
		if (det > 0) return 2 * c / (Math.sqrt(det) - b);
		else return -1;
	},
	
	/**
	* getAimPoint(p1, p2, v1, v2, spd);
	*  - returns a vector that represents the direction to aim at.
	*     null if the position is impossible to calculate.
	*  - p1 and p2 are position vectors for player and target, respectively.
	*  - v1 and v2 are velocity vectors for player and target, respectively.
	*  - spd is the speed (or velocity) of the player's projectile.
	**/
	getAimPoint: function(p1, p2, v1, v2, spd) {
		var delta = this.subtractVectors(p1, p2);
		var vr    = this.subtractVectors(v1, v2);
		var time  = this.aimAheadTime(delta, vr, spd);
		
		if (t > 0)
			return this.addVectors(p2, this.scaleVectors(vr, time));
		else return null;
	},
});